#!/bin/sh

dir="/"
root="/root"
blk="/dev/mmcblk1"
p2="/tmp/p2"
p3="/tmp/p3"
upgrade_script="/osupgrade.sh"
bootflag="bootflag"
bootflag_location="/sbin/bootflag"
upgrade_zip="OSUpgrade.zip"
upgrade_in_dir="OSUpgrade"
zImage="zImage"
upgrade_zip_md5="OSUpgrade_md5sum"
log_file="/upgrade.log"
reboot="/sbin/reboot"
upgrade_p2="${root}/upgrade_p2"
upgrade_p3="${root}/upgrade_p3"
upgrade_p4="${root}/upgrade_p4"
launchapp="${root}/launchapp.sh"
USB_drive="/media/*${dev_type}*"
dev_null="/dev/null"
check_version="${root}/check_version"
ver_file="SW_Ver.txt"
progressBar="/upgradeStatus"

remove_package()
{
    echo "Info: Removing old upgrade package" >> ${log_file}
    if [ -d ${root}/${upgrade_in_dir} ]; then
        rm -rf ${root}/${upgrade_in_dir}
    fi

    cd ${dir}
}

check_dependencies()
{
    if [ ! -f ${p2}/${upgrade_script} ] || [ ! -f ${p2}/${progressBar} ] || [ ! -f ${p2}/${bootflag_location} ] || [ ! -f ${upgrade_script} ] || [ ! -f ${progressBar} ] || [ ! -f ${bootflag_location} ]; then
        echo "WARNING: ${p2}/${upgrade_script} or ${p2}/${progressBar} or ${p2}/${bootflag_location} or ${upgrade_script} or ${progressBar} or ${bootflag_location} Not Found, Exiting..." >> ${log_file}
        if [ -f ${upgrade_p2} ]; then
            rm -rf ${upgrade_p2}
        fi
        if [ -f ${upgrade_p3} ]; then
            rm -rf ${upgrade_p3}
        fi
        if [ -f ${upgrade_p4} ]; then
            rm -rf ${upgrade_p4}
        fi
        exit 1
    fi
}

kill_all()
{
    echo "Info: Killing all running applications from ${root}" >> ${log_file}

    src="ThunderStorm launchapp SheepApp i2cget run_nmap_in_bg sleep"
    for i in ${src}; do
        PID=`ps | grep -i "$i" | grep -v grep | awk '{print $1}'`
        if [[ "" !=  "$PID" ]]; then
            echo "Info: killing "$i" process $PID" >> ${log_file}
            kill -9 $PID
            if ! [ $? = 0 ]; then
                echo "WARNING: Failed to kill "$i" process $PID" >> ${log_file}
                exit 1
            fi
            sleep 2
        fi
    done
}

compare_md5()
{
    if [ -f ${root}/${upgrade_zip_md5} ]; then
        md5OSUpgrade=`md5sum ${root}/${upgrade_zip} | awk '{print $1}'`
        echo "Info: ${root}/${upgrade_zip} md5sum $md5OSUpgrade" >> ${log_file}

        md5=`cat ${root}/${upgrade_zip_md5}`
        echo "Info: ${root}/${upgrade_zip_md5} file ${md5}" >> ${log_file}

        if [ ${md5OSUpgrade} != ${md5} ]; then
            echo "WARNING: md5 comparision failed, exiting" >> ${log_file}
            exit 1
        fi
    fi
}

unzip_upgrade()
{
    kill_all
    compare_md5
    cd ${root}
    echo "Info: unzipping upgrade" >> ${log_file}
    if [ ! -d ${root}/${upgrade_in_dir} ]; then
        mkdir -p ${root}/${upgrade_in_dir}
    fi
    unzip ${root}/${upgrade_zip} -d ${root}/${upgrade_in_dir}
    if ! [ $? = 0 ]; then
        echo "WARNING: Failed to unzip ${root}/${upgrade_zip}" >> ${log_file}
        exit 1
    fi
}

check_for_upgrade()
{
    if [ ! -f ${root}/${upgrade_zip} ]; then
        if [ ! -d ${root}/${upgrade_in_dir} ]; then
            echo "WARNING: Update Not Found, Exiting..." >> ${log_file}
            if [ -f ${upgrade_p2} ]; then
                rm -rf ${upgrade_p2}
            fi
            if [ -f ${upgrade_p3} ]; then
                rm -rf ${upgrade_p2}
            fi
            if [ -f ${upgrade_p4} ]; then
                rm -rf ${upgrade_p2}
            fi
            exit 1
        fi
    else
        if [ -d ${root}/${upgrade_in_dir} ]; then
            rm -rf ${root}/${upgrade_in_dir}
        fi
        unzip_upgrade
    fi 
}

remove_osupgrade_package()
{
    echo "Info: Removing ${root}/${upgrade_zip} and ${root}/${upgrade_zip_md5}, if available" >> ${log_file}
    if [ -f ${root}/${upgrade_zip} ]; then
        rm ${root}/${upgrade_zip}
    fi
    if [ -f ${root}/${upgrade_zip_md5} ]; then
        rm ${root}/${upgrade_zip_md5}
    fi
}

check_for_usb_upgrade()
{
    if [ ! -f ${USB_drive}/${upgrade_zip} ]; then
        if [ -d ${USB_drive}/${upgrade_in_dir} ]; then
            cp -r ${USB_drive}/${upgrade_in_dir} ${root}
        else
            echo "WARNING: Update Not Found in USB Drive, Exiting..." >> ${log_file}
            exit 1
        fi
    else
        echo "Info: Copying ${upgrade_zip} to ${root}, it may take some time to copy" >> ${log_file}
        rsync --info=progress2 ${USB_drive}/${upgrade_zip} ${root}
        if [ -f ${USB_drive}/${upgrade_zip_md5} ]; then
            echo "Info: Copying ${upgrade_zip_md5} to ${root}" >> ${log_file}
            rsync --info=progress2 ${USB_drive}/${upgrade_zip_md5} ${root}
        fi
    fi
    if [ -d ${USB_drive}/${upgrade_in_dir} ]; then
        rm -rf ${USB_drive}/${upgrade_in_dir}
    fi
}

check_for_upgrade_version()
{
    if [ ! -d ${root}/${upgrade_in_dir} ]; then
        if [ ! -f ${root}/${upgrade_zip} ]; then
            echo "Info: Upgrade not available in ${root}, checking in ${USB_drive}" >> ${log_file}
            if [ ! -d ${USB_drive}/${upgrade_in_dir} ]; then
                if [ ! -f ${USB_drive}/${upgrade_zip} ]; then
                    echo "WARNING: Update Not Found in USB Drive, Exiting..." >> ${log_file}
                    echo "UPGRADE_NOT_FOUND"
                    exit 1
                else
                    cp ${USB_drive}/${upgrade_zip} ${root}
                fi
            else
                cp -r ${USB_drive}/${upgrade_in_dir} ${root}
            fi
        fi
    fi

    #TODO: create logic to get version from directory 
    echo "Info: Creating directory to copy upgrade" >> ${log_file}
    if [ -d ${check_version} ]; then
        rm -rf ${check_version}
    fi
    mkdir -p ${check_version}
    echo "Info: Copying Upgrade to ${check_version}, it may take some time" >> ${log_file}
    cp ${root}/${upgrade_zip} ${check_version}
    cd ${check_version}
    echo "Info: Extracting the upgrade to get version file" >> ${log_file}
    unzip ${check_version}/${upgrade_zip} -d ${check_version} > ${dev_null}
    if [ -f ${ver_file} ]; then
        echo "Info: Upgrade version is : $(cat ${ver_file})" >> ${log_file}
        cat ${ver_file}
    fi
    cd ${root}
    echo "Info: Removing upgrade directory" >> ${log_file}
    rm -rf ${check_version}
    cd ${dir}
    echo "Info: Exiting the script..." >> ${log_file}
    exit 1
}

mount_P2()
{
    echo "Info: creating ${p2}" >> ${log_file}
    mkdir -p ${p2}
    if ! [ $? = 0 ]; then
        echo "WARNING: Failed to create directory ${p2}" >> ${log_file}
        exit 1
    fi
    echo "Info: mounting ${p2}" >> ${log_file}
    mount -t ext4 ${blk}p2 ${p2}
    if [ $? != 0 ]; then
        echo y|mkfs.ext4 -c ${blk}p2
        if [ $? != 0 ]; then
            echo "WARNING: Failed to mount ${blk}p2 to ${p2} in mkfs.ext4" >> ${log_file}
            exit 1
        fi
        mount -t ext4 ${blk}p2 ${p2}
        if [ $? != 0 ]; then
            echo "WARNING: Failed to mount ${blk}p2 to ${p2}" >> ${log_file}
            exit 1
        fi
    fi
    sleep 1
}

umount_P2()
{
    echo "Info: unmounting ${p2}" >> ${log_file}
    if [ -d ${p2} ]; then
        if mount | grep -i "/dev/mmcblk1p2 on /tmp/p2" > ${dev_null}; then
            umount ${p2}
            if ! [ $? = 0 ]; then
                echo "WARNING: Failed to unmount ${p2}" >> ${log_file}
                exit 1
            fi
        fi
        rm -rf ${p2}
    fi
}

set_env_upgrade()
{
    if ! [ -f ${root}/${upgrade_in_dir}/${upgrade_script} ]; then
        echo "WARNING: Upgrade script not found!!!" >> ${log_file}
        exit 1
    fi

    if [ -f ${p2}/${upgrade_script} ]; then
        rm ${p2}/${upgrade_script}
    fi
    if [ -f ${p2}/${progressBar} ]; then
        rm ${p2}/${progressBar}
    fi
    if [ -f ${p2}/${bootflag_location} ]; then
        rm ${p2}/${bootflag_location}
    fi
    cp ${root}/${upgrade_in_dir}/${upgrade_script} ${p2}/${upgrade_script}
    cp ${root}/${upgrade_in_dir}/${progressBar} ${p2}/${progressBar}
    cp ${root}/${upgrade_in_dir}/${bootflag} ${p2}/${bootflag_location}
    cp ${root}/${upgrade_in_dir}/${upgrade_script} ${upgrade_script}
    cp ${root}/${upgrade_in_dir}/${progressBar} ${progressBar}
    cp ${root}/${upgrade_in_dir}/${bootflag} ${bootflag_location}
    chmod 777 ${p2}/${progressBar}
    chmod 777 ${p2}/${bootflag_location}
    chmod 777 ${progressBar}
    chmod 777 ${bootflag_location}

    sleep 2
    cd ${dir}
}

start_script()
{
    echo "Info: unzip upgrade script version : 2.3.2" > ${log_file}

    if ! mount | grep -i "/dev/mmcblk1p4 on /root" > ${dev_null}; then
        echo "WARNING: /root not mounted..." >> ${log_file}
        echo "WARNING: Please reboot the device or mount ${root} and restart the upgrade..." >> ${log_file}
        exit
    fi

    if [ "$1" == "USB_UPGRADE" ]; then
        remove_osupgrade_package
        check_for_usb_upgrade
    elif [ "$1" == "GET_VERSION" ]; then
        #check_for_upgrade_version
        echo "Info: Feature under develpoment..." >> ${log_file}
        echo "Info: Feature under develpoment..."
    fi

    check_for_upgrade
    umount_P2
    mount_P2
    set_env_upgrade
    check_dependencies
    umount_P2

    if [ ! -f ${root}/${upgrade_in_dir}/${zImage} ]; then
        sh ${upgrade_script} "start_APP_upgrade" &
    else
        sh ${upgrade_script} "start_OS_upgrade" &
    fi
}

start_script $1
